// PageSettingCuster.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingCuster.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "DecCtrlClientTypes.h"

// CPageSettingCuster Ի

IMPLEMENT_DYNAMIC(CPageSettingCuster, CDialog)

CPageSettingCuster::CPageSettingCuster(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingCuster::IDD, pParent)
{

}

CPageSettingCuster::~CPageSettingCuster()
{
}

void CPageSettingCuster::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB6, m_TabCuster);
}


BEGIN_MESSAGE_MAP(CPageSettingCuster, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB6, &CPageSettingCuster::OnTcnSelchangeTab6)
END_MESSAGE_MAP()


// CPageSettingCuster Ϣ
int CPageSettingCuster::Initialize(LONG _lLogonID)
{
	if (_lLogonID < 0)
	{
		return -1;
	}
	m_lLogonID = _lLogonID;
	m_pageDevice.SetLogonID(_lLogonID);
	m_pageState.SetLogonID(_lLogonID);
	m_pageDeviceIP.SetLogonID(_lLogonID);
	m_pageBasicInfo.SetLogonID(_lLogonID);
	m_pageDeviceInfo.SetLogonID(_lLogonID);

	memset(&m_decParam,0,sizeof(m_decParam));
	DEC_ClientGetDecoderPara(_lLogonID,&m_decParam);

	return 0;
}
BOOL CPageSettingCuster::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_TabCuster.InsertItem(0, GetText(IDS_DEVICE_MANAGE));
	m_TabCuster.InsertItem(1, GetText(IDS_STATE));
	m_TabCuster.InsertItem(2, GetText(IDS_MAIN_CONNECT_MODE_IP));
	m_TabCuster.InsertItem(3, GetText(IDS_BISIC_INFO));
	m_TabCuster.InsertItem(4, GetText(IDS_DEVICE_INFO));

	m_pageDevice.Create(IDD_DIALOG_DEVICE, &m_TabCuster);
	m_pageState.Create(IDD_DIALOG_STATE, &m_TabCuster);
	m_pageDeviceIP.Create(IDD_DIALOG_DEVICE_IP, &m_TabCuster);
	m_pageBasicInfo.Create(IDD_DIALOG_BASIC_INFO, &m_TabCuster);
	m_pageDeviceInfo.Create(IDD_DIALOG_DEVICE_INFO, &m_TabCuster);
	CRect rc;
	m_TabCuster.GetClientRect(rc);
	rc.top += 21;
	rc.bottom -= 5;
	rc.left += 3;
	rc.right -= 5;

	m_pageDevice.MoveWindow(&rc);
	m_pageState.MoveWindow(&rc);
	m_pageDeviceIP.MoveWindow(&rc);
	m_pageBasicInfo.MoveWindow(&rc);
	m_pageDeviceInfo.MoveWindow(&rc);

	m_pDialog[0] = &m_pageDevice;
	m_pDialog[1] = &m_pageState;
	m_pDialog[2] = &m_pageDeviceIP;
	m_pDialog[3] = &m_pageBasicInfo;
	m_pDialog[4] = &m_pageDeviceInfo;

	m_pageDevice.Initialize(&m_decParam);
	m_pageState.Initialize(&m_decParam);
	m_pageDeviceIP.Initialize(&m_decParam);
	m_pageBasicInfo.Initialize(&m_decParam);
	m_pageDeviceInfo.Initialize(&m_decParam);

	m_pDialog[0]->ShowWindow(SW_SHOW);
	m_pDialog[1]->ShowWindow(SW_HIDE);
	m_pDialog[2]->ShowWindow(SW_HIDE);
	m_pDialog[3]->ShowWindow(SW_HIDE);
	m_pDialog[4]->ShowWindow(SW_HIDE);
	this->SetWindowText(GetText(IDS_SETTING_SET));
	//浱ǰѡ
	m_iCurSelTab = 0;
	return FALSE;
}


void CPageSettingCuster::OnTcnSelchangeTab6(NMHDR *pNMHDR, LRESULT *pResult)
{
	m_pDialog[m_iCurSelTab]->ShowWindow(SW_HIDE);
	m_iCurSelTab = m_TabCuster.GetCurSel();
	m_pDialog[m_iCurSelTab]->ShowWindow(SW_SHOW);
	*pResult = 0;
}

void CPageSettingCuster::OnMainNotify( _MAIN_NOTIFY_DATA* _pData )
{
	m_pageDevice.OnMainNotify(_pData);
}
